import numpy as np

def select_flat_window(R_kpc, Vobs_kms, dvdr_max, min_points, min_radius_kpc, min_span_kpc):
    R = np.asarray(R_kpc); V = np.asarray(Vobs_kms)
    dV = np.gradient(V, R)
    mask = (np.abs(dV) <= dvdr_max) & (R >= min_radius_kpc)
    best = (None,None,0.0); i=0
    while i < len(mask):
        if mask[i]:
            j=i
            while j < len(mask) and mask[j]: j+=1
            if (j-1)-i+1 >= min_points and (R[j-1]-R[i]) >= min_span_kpc:
                span = R[j-1]-R[i]
                if span > best[2]: best=(i,j-1,span)
            i=j
        else:
            i+=1
    if best[0] is None: return 0,0,False
    return best[0], best[1], True

def mesh_refine(Vobs_kms, factor=0.5):
    import numpy as np
    V = np.asarray(Vobs_kms)
    if factor >= 1.0 or factor <= 0.0: return V.copy()
    mids = (V[:-1] + V[1:])/2.0
    out = np.empty((len(V)+len(mids),), float)
    out[0::2]=V; out[1::2]=mids
    return out
